<?php
include 'config/init.php';
?>
<!doctype html>
<html lang="tr">
<head>
    <meta charset="utf-8" />
    <title>Giriş Seçimi | E-Mentor App</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link href="assets/css/bootstrap.min.css" rel="stylesheet">
    <link href="assets/css/app.min.css" rel="stylesheet">
    <link rel="stylesheet" href="assets/libs/flatpickr/flatpickr.min.css">
    <link href="assets/css/icons.min.css" rel="stylesheet" type="text/css" />
</head>
<body>
<div class="position-fixed top-0 end-0 p-3" style="z-index: 1055">
    <div id="time-toast" class="toast" role="alert" aria-live="assertive" aria-atomic="true">
        <div class="toast-header"><strong class="me-auto">E-Mentor Zaman Makinesi</strong><button type="button" class="btn-close" data-bs-dismiss="toast"></button></div>
        <div class="toast-body"></div>
    </div>
</div>

<div class="d-flex min-vh-100">
    <div class="auth-bg flex-fill position-relative"><div class="bg-overlay"></div></div>
    <div class="container position-absolute top-50 start-50 translate-middle">
        <div class="row justify-content-center">
            <div class="col-lg-10">
                <div class="card shadow-lg">
                    <div class="card-body text-center py-5">
                        <h2 class="fw-bold mb-3">E-Mentor'a Hoş Geldiniz</h2>
                        <p class="text-muted mb-4">Devam etmek için kullanıcı türünüzü seçin</p>
                        <div class="row g-5">
                            <div class="col-md-4"><a href="giris-ogrenci.php" class="btn btn-primary fs-5 w-100 py-3">Öğrenci Girişi</a></div>
                            <div class="col-md-4"><a href="giris-ogretmen.php" class="btn btn-success fs-5 w-100 py-3">Öğretmen Girişi</a></div>
                            <div class="col-md-4"><a href="#" class="btn btn-secondary fs-5 w-100 py-3 disabled">Veli Girişi (Yakında)</a></div>
                        </div>
                    </div>

                    <div class="card-footer bg-light">
                        <div class="row align-items-center">
                            <div class="col-sm-4 text-sm-start text-center">
                                <h6 class="mb-sm-0 mb-2"><i class="bx bx-time-five me-2"></i>ZAMAN MAKİNESİ</h6>
                            </div>
                            <div class="col-sm-8">
                                <input type="text" class="form-control" id="time-machine-datepicker" placeholder="Simülasyon için bir tarih seçin...">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script src="assets/libs/jquery/jquery.min.js"></script>
<script src="assets/libs/bootstrap/js/bootstrap.bundle.min.js"></script>
<script src="https://npmcdn.com/flatpickr/dist/l10n/tr.js"></script>
<script src="assets/libs/flatpickr/flatpickr.min.js"></script>
<script>
    document.addEventListener('DOMContentLoaded', function() {
        const toastEl = document.getElementById('time-toast');
        const toast = new bootstrap.Toast(toastEl);

        flatpickr("#time-machine-datepicker", {
            enableTime: true,
            dateFormat: "d-m-Y H:i",
            locale: 'tr',
            defaultDate: "<?= (new DateTime(SIMULATED_NOW))->format('d-m-Y H:i') ?>",
            onChange: function(selectedDates, dateStr, instance) {
                // Tarih değiştiğinde AJAX ile backend'e gönder
                $.ajax({
                    url: 'islemler/set-zaman.php',
                    type: 'POST',
                    data: { new_date: dateStr },
                    dataType: 'json',
                    success: function(response) {
                        if (response.success) {
                            $('#time-toast .toast-body').text(response.message);
                            toast.show();
                        }
                    }
                });
            }
        });
    });
</script>

</body>
</html>